#include <bits/stdc++.h>

using namespace std;

const int N = 2e5 + 10;
int n;
int a[N];
vector<int> g[N];
long long dp[N][2];
vector<int> ans[2];

void dfs(int u, int par) {
    dp[u][1] = a[u];
    for(int v : g[u]) {
        if(v == par) continue;
        dfs(v, u);
        dp[u][0] += dp[v][1];
        dp[u][1] += min(dp[v][0], dp[v][1]);
    }
}

void solve(int u, int par, int force, int color) {
    if(force == -1) {
        if(dp[u][0] < dp[u][1]) force = 0;
        else force = 1;
    }
    if(force == 0) {
        for(int v : g[u]) {
            if(v == par) continue;
            solve(v, u, 1, color ^ 1);
        }
    } else {
        ans[color].push_back(u);
        for(int v : g[u]) {
            if(v == par) continue;
            solve(v, u, -1, color ^ 1);
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cin >> n;
    for(int i = 1; i <= n; i++) cin >> a[i];
    for(int i = 1; i < n; i++) {
        int u, v;
        cin >> u >> v;
        g[u].push_back(v);
        g[v].push_back(u);
    }
    dfs(1, 0);
    cout << min(dp[1][0], dp[1][1]) << "\n";
    solve(1, 0, -1, 0);
    cout << ans[0].size() << "\n";
    for(int i : ans[0]) cout << i << " ";
    cout << "\n\n" << ans[1].size() << "\n";
    for(int i : ans[1]) cout << i << " ";
    return 0;
}